;==============================================================================
; BitCountSlow
;------------------------------------------------------------------------------

; Counts the bits in a value using shifts. This example shows the structured
; assembly commands.
;
;==============================================================================
; Revision History
;
; 13-08-2007 AJ First Release
;------------------------------------------------------------------------------
; $Id$
;------------------------------------------------------------------------------

                .6502

                .GLOBAL BitCountSlow

                .CODE

; This small iterative alogithim shifts the value in A and counts the number of
; one bits (using X) until the value becomes zero.
;
; On entry: A = value to be counted.
; On exit:  A & X = bit count, Y unchanged.

BitCountSlow:   LDX #0
                REPEAT
                 ASL A
                 PHP
                 IF CS
                  INX
                 ENDIF
                 PLP
                UNTIL EQ
                TXA
                RTS

                .END